
public class BufferBlock {
	private long startAddress;
	private byte[] bytes;
	private int size;
	private BufferBlock prev;
	private BufferBlock next;
	private boolean dirtyBit;
	
	public BufferBlock(int sz) {
		setStartAddress(-1);
		bytes = new byte[sz];
		this.size = sz;
		prev = null;
		next = null;
		setDirtyBit(false);
	}
	
	// Copies size bytes starting from address to out
	public void getBytes(byte[] out, int address, int size) {
		for (int i = 0; i < size; i++) {
			out[i] = bytes[address + i];
		}
	}
	
	// Puts size bytes starting from address from in
	public void setBytes(byte[] in, int address, int size) {
		for (int i = 0; i < size; i++) {
			bytes[address + i] = in[i]; 
		}
	}
	
	public BufferBlock getPrev() {
		return prev;
	}
	public void setPrev(BufferBlock prev) {
		this.prev = prev;
	}
	public BufferBlock getNext() {
		return next;
	}
	public void setNext(BufferBlock next) {
		this.next = next;
	}
	public int getSize() {
		return size;
	}
	public boolean isDirtyBit() {
		return dirtyBit;
	}
	public void setDirtyBit(boolean dirtyBit) {
		this.dirtyBit = dirtyBit;
	}
	public long getStartAddress() {
		return startAddress;
	}
	public void setStartAddress(long startAddress) {
		this.startAddress = startAddress;
	}
}
